
DROP PROCEDURE IF EXISTS sp_reporteKardexProducto;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_reporteKardexProducto`(IN `p_idProducto` INT, IN `p_anio` INT, IN `tipoOperacion` INT)
BEGIN      
    DECLARE nFilas int;
    DECLARE v_idProducto int;    
    DECLARE v_idDetaNota int;
    DECLARE v_fechaEmision datetime;
    DECLARE v_fechaContable datetime;
    
    DECLARE v_precioUnitarioSalida decimal(18,2);
    
    DECLARE v_cantidadEntrada decimal(18,2);
    DECLARE v_costoUnitarioEntrada decimal(18,2);
    DECLARE v_costoTotalEntrada decimal(18,2);
    
    DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_costoUnitarioSalida decimal(18,2);
    DECLARE v_costoTotalSalida decimal(18,2);
    
    DECLARE v_cantidadSaldo decimal(18,2);
    DECLARE v_costoUnitarioSaldo decimal(18,2);
    DECLARE v_costoTotalSaldo decimal(18,2);
    
    DECLARE nFilas2 int;
	DECLARE v_idDetaNota2 int;
    
    DECLARE v_tipoNota char(5);
    DECLARE v_contador int;
    
    IF tipoOperacion = 1 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idProducto, 	date(NA.fechaEmision) as fechaEmision,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,				
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadIngresada', 
								CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioIngresado',
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoIngresado',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
				                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSalida',
				                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'montoSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSaldo',
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoSaldo',
				NA.tipoNota, 1 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaEmision) = p_anio
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc );
		
        
                
		CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp WHERE tipoNota = 'S');
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
		
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaEmision, cantidadSalida, precioUnitarioSalida 
			 INTO @v_idDetaNota, @fechaEmision, @v_cantidadSalida, @v_precioUnitarioSalida
			 FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			 ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
			
			(SELECT ifnull( sum(case when cantidadSaldo = '' then 0.00 else ifnull(cantidadSaldo, 0.00) end), 0.00 ) into @v_cantidadSaldo 
					FROM kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1);
			
						UPDATE kardex_temp SET activo = 0 WHERE idDetaNota = @v_idDetaNota;
			
						
			UPDATE kardex_temp2 SET activo = 0 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida;
			
			UPDATE kardex_temp2 
			SET cantidadSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN ''
									ELSE CAST(@v_cantidadSaldo - @v_cantidadSalida AS decimal(18,2)) END), 
				precioUnitarioSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
										ELSE @v_precioUnitarioSalida END ),
				montoSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
								   ELSE CAST(  (@v_cantidadSaldo - @v_cantidadSalida)*@v_precioUnitarioSalida AS decimal(18,2)) END),
				activo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN  0
									ELSE 1 END)
			WHERE idDetaNota = @v_idDetaNota;
			
			SET @nFilas = @nFilas - 1;        
		END WHILE;
		
				        
        SELECT idDetaNota, idProducto, fechaEmision, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			
            cantidadIngresada as cantidadEntrada, 
            precioUnitarioIngresado as costoUnitarioEntrada, 
            montoIngresado as costoTotalEntrada, 
            
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, 
            precioUnitarioSalida as costoUnitarioSalida, 
            montoSalida as costoTotalSalida,
			
            case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else precioUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else montoSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
    
    IF tipoOperacion = 2 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idProducto, 	NA.fechaEmision,	
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' THEN NA.tipoDocumento ELSE '' END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.serieDocumento ELSE '' END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.numeroDocumento ELSE '' END AS numeroDocumento,
				CASE WHEN NA.tipoNota = 'S' THEN UM.placa ELSE '' END AS placa,
				NA.tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadIngresada', 
				CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioIngresado',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoIngresado',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
				CASE WHEN NA.tipoNota = 'S' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSalida',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.monto ELSE '' END AS 'montoSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				CASE WHEN NA.tipoNota = 'E' THEN DNA.precioUnitario ELSE '' END AS 'precioUnitarioSaldo',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.monto ELSE '' END AS 'montoSaldo',
				NA.tipoNota, 1 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		WHERE year(NA.fechaEmision) = p_anio
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc);
		
		CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp WHERE tipoNota = 'S');
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
		
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, idProducto, fechaEmision, cantidadSalida, precioUnitarioSalida 
			 INTO @v_idDetaNota, @v_idProducto, @fechaEmision, @v_cantidadSalida, @v_precioUnitarioSalida
			 FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			 ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
             
			(SELECT ifnull(sum(case when cantidadSaldo = ''  then 0.00
							when cantidadSaldo is null then 0.00 
							else cantidadSaldo end), 0.00) into @v_cantidadSaldo 
					FROM kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota and idProducto = @v_idProducto
									and precioUnitarioSaldo = @v_precioUnitarioSalida  and activo = 1);
			            		                
						UPDATE kardex_temp SET activo = 0 WHERE idDetaNota = @v_idDetaNota;
			
						
			UPDATE kardex_temp2 SET activo = 0 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
								and idProducto = @v_idProducto and precioUnitarioSaldo = @v_precioUnitarioSalida;
			
			UPDATE kardex_temp2 
			SET cantidadSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
									ELSE CAST(@v_cantidadSaldo - @v_cantidadSalida AS decimal(18,2)) END), 
				precioUnitarioSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
										ELSE @v_precioUnitarioSalida END ),
				montoSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
								   ELSE CAST(  (@v_cantidadSaldo - @v_cantidadSalida)*@v_precioUnitarioSalida AS decimal(18,2)) END),
				activo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN  0
									ELSE 1 END)
			WHERE idDetaNota = @v_idDetaNota;
			
			SET @nFilas = @nFilas - 1;        
		END WHILE;
		
				SELECT * FROM kardex_temp2;
	END IF;
    
    IF tipoOperacion = 3 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaEmision) as fechaEmision,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada', 
								CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
				CASE WHEN NA.tipoNota = 'S' THEN sum(DNA.cantidadTotal) ELSE 0 END AS 'cantidadSalida', 
				                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
				                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaEmision) = p_anio
        GROUP BY DNA.idNotaAlmacen,  DNA.idProducto
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaEmision, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @fechaEmision, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
                
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaEmision, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
    
    IF tipoOperacion = 4 THEN
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idProducto, 	date(NA.fechaEmision) as fechaEmision,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaEmision ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaEmision ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaEmision, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' THEN NA.tipoDocumento ELSE '' END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.serieDocumento ELSE '' END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' THEN NA.numeroDocumento ELSE '' END AS numeroDocumento,
				(CASE WHEN NA.tipoNota = 'S' and NA.idOrdenMantenimiento is not null THEN UM1.placa
					  WHEN NA.tipoNota = 'S' and NA.idOrdenServicio is not null THEN UM2.placa 
				ELSE '' END) AS placa,
				                M2.descripcion as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadIngresada', 
								CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioIngresado',
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoIngresado',
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
				                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSalida',
				                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'montoSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'precioUnitarioSaldo',
				                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'montoSaldo',
				NA.tipoNota, 1 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM1 ON UM1.idUnidad = OM.idUnidad
		LEFT JOIN UNIDAD_MOVIL UM2 ON UM2.idUnidad = OS.idUnidad
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaEmision) = p_anio
		ORDER BY date(NA.fechaEmision) asc, DNA.idDetaNota asc );
		
                
		CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaEmision) asc, idDetaNota asc);
		
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp WHERE tipoNota = 'S');
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
		
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaEmision, cantidadSalida, precioUnitarioSalida 
			 INTO @v_idDetaNota, @fechaEmision, @v_cantidadSalida, @v_precioUnitarioSalida
			 FROM kardex_temp WHERE tipoNota = 'S' and activo = 1
			 ORDER BY date(fechaEmision) asc, idDetaNota asc limit 1);
			
			(SELECT ifnull( sum(case when cantidadSaldo = '' then 0.00 else ifnull(cantidadSaldo, 0.00) end), 0.00 ) into @v_cantidadSaldo 
					FROM kardex_temp2 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida and activo = 1);
			
						UPDATE kardex_temp SET activo = 0 WHERE idDetaNota = @v_idDetaNota;
			
						
			UPDATE kardex_temp2 SET activo = 0 WHERE fechaEmision <= @fechaEmision and idDetaNota < @v_idDetaNota 
									and precioUnitarioSaldo = @v_precioUnitarioSalida;
			
			UPDATE kardex_temp2 
			SET cantidadSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN ''
									ELSE CAST(@v_cantidadSaldo - @v_cantidadSalida AS decimal(18,2)) END), 
				precioUnitarioSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
										ELSE @v_precioUnitarioSalida END ),
				montoSaldo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN '' 
								   ELSE CAST(  (@v_cantidadSaldo - @v_cantidadSalida)*@v_precioUnitarioSalida AS decimal(18,2)) END),
				activo = ( CASE WHEN (@v_cantidadSaldo - @v_cantidadSalida) = 0 THEN  0
									ELSE 1 END)
			WHERE idDetaNota = @v_idDetaNota;
			
			SET @nFilas = @nFilas - 1;        
		END WHILE;
		
				SELECT * FROM kardex_temp2;
	END IF;
    
	IF tipoOperacion = 5 THEN
		SELECT P.idProducto, P.nombre, P.unidad_medida, M1.descripcion as 'unidadMedida', 
			P.tipo_existencia, CONCAT(P.tipo_existencia, ' ', M2.descripcion) as 'tipoExistencia',
            (SELECT direccion FROM OFICINA WHERE principal = 1 limit 1) as establecimiento,
			(SELECT ruc FROM EMPRESA WHERE idEmpresa = 1) as ruc,
            (SELECT razonSocial FROM EMPRESA WHERE idEmpresa = 1) as razonSocial         
		FROM PRODUCTO P 
		INNER JOIN MULTITABLA M1 ON M1.abrev = P.unidad_medida and M1.dep_id = 3
		INNER JOIN MULTITABLA M2 ON M2.abrev = P.tipo_existencia and M2.dep_id = 14
		WHERE P.idProducto = p_idProducto;
    END IF;
    
	IF tipoOperacion = 6 THEN
		SELECT NA.idNotaAlmacen, NA.fechaEmision, DNA.idProducto
		FROM NOTA_ALMACEN NA
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen and year(NA.fechaEmision) = p_anio and NA.estado = 'C'
		GROUP BY DNA.idProducto;
    END IF;
    
    IF tipoOperacion = 7 THEN
		SELECT NA.idNotaAlmacen, NA.fechaEmision, DNA.idProducto
		FROM NOTA_ALMACEN NA
		INNER JOIN DETALLE_NOTA_ALMACEN DNA ON DNA.idNotaAlmacen = NA.idNotaAlmacen 
			and year(NA.fechaContable) = p_anio and NA.estado = 'C' and DNA.idProducto = p_idProducto
		GROUP BY DNA.idProducto;
    END IF;
    
    IF tipoOperacion = 8 THEN -- PEPS
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '00' 
					 WHEN NA.tipoNota = 'S' THEN '00'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 -- WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 -- WHEN NA.tipoNota = 'S'  THEN '001'
                     WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NE'
                     WHEN NA.tipoNota = 'S'  THEN ''
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 -- WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				-- END as tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN concat(M2.Abrev, '-', M2.descripcion)
					 WHEN NA.tipoNota = 'S' THEN concat(M3.Abrev, '-', M3.descripcion ) 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
								CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 1 as activo, 0 cantidadUsada
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaContable) = p_anio
        		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
        
		CREATE TEMPORARY TABLE kardex_temp2(SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		delete from kardex_temp2;
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        set @contador = 1;
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
				@v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
                
			IF(@contador = 1) THEN
				INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
					tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
					cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
					cantidadSalida, costoUnitarioSalida, costoTotalSalida,
					cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
				SELECT * 
				FROM kardex_temp LIMIT 1;
                
                set @contador = 2;
			ELSE
				DROP TEMPORARY TABLE IF EXISTS temp_entradas;
				
				CREATE TEMPORARY TABLE temp_entradas (
					SELECT * FROM kardex_temp2 
					WHERE fechaContable <= @v_fechaContable AND activo = 1 AND tipoNota = 'E'
				);
                SET @nFilas2 = (SELECT count(*) FROM temp_entradas);
				                
				IF ( @v_tipoNota = 'E') THEN
                        
					INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
						tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
						cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
						cantidadSalida, costoUnitarioSalida, costoTotalSalida,
						cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
					SELECT *
					FROM kardex_temp WHERE idDetaNota = @v_idDetaNota;
                    
                    WHILE @nFilas2 > 0 DO
						SET @v_idDetaNota2 = 0;
						SET @v_cantidadSaldo = 0;
                        
						SELECT idDetaNota, cantidadEntrada - cantidadUsada
						INTO @v_idDetaNota2, @v_cantidadSaldo
						FROM temp_entradas 
                        WHERE activo = 1 and costoUnitarioEntrada =  @v_costoUnitarioEntrada
						ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                        
                        UPDATE kardex_temp2 
                        SET cantidadSaldo = cast( round(cantidadSaldo + @v_cantidadSaldo, 2)  as decimal(18,2)),
							costoTotalSaldo = cast( round( cantidadSaldo * costoUnitarioSaldo, 2)  as decimal(18,2))
                        WHERE idDetaNota = @v_idDetaNota;
                        
						UPDATE kardex_temp2
                        SET cantidadUsada = cast( round(cantidadSaldo, 2)  as decimal(18,2)),
							activo = 0
                        WHERE idDetaNota = @v_idDetaNota2;
                        
						SET @nFilas2 = @nFilas2 - 1;
					END WHILE;
				ELSE 
					WHILE @nFilas2 > 0 and @v_cantidadSalida > 0 DO
						set @v_idDetaNota2 = 0;
						set @v_cantidadSaldo = 0;
                        set @v_costoUnitarioEntrada = 0;
                        
						SELECT idDetaNota, costoUnitarioEntrada, cantidadEntrada - cantidadUsada
						INTO @v_idDetaNota2, @v_costoUnitarioEntrada, @v_cantidadSaldo
						FROM temp_entradas 
                        WHERE activo = 1
						ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                        
                        IF @v_cantidadSalida <= @v_cantidadSaldo THEN
                        
							UPDATE kardex_temp2 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSalida, 
								activo = ( CASE WHEN  @v_cantidadSalida = @v_cantidadSaldo THEN 0 ELSE 1 END)
							WHERE idDetaNota = @v_idDetaNota2;
                            
                            UPDATE kardex_temp2 SET activo = 0  WHERE tipoNota = 'S' and costoUnitarioSaldo = @v_costoUnitarioEntrada;
                            
                            INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cantidadSalida, costoUnitarioSalida, costoTotalSalida,
								cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
							SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cast( round(@v_cantidadSalida, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round(cantidadSalida * @v_costoUnitarioEntrada, 2)  as decimal(18,2)),
								cast( round(@v_cantidadSaldo - @v_cantidadSalida, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round( (@v_cantidadSaldo - @v_cantidadSalida)  * @v_costoUnitarioEntrada, 2)  as decimal(18,2)), 
								tipoNota, activo, cantidadUsada
							FROM kardex_temp k WHERE idDetaNota = @v_idDetaNota;
                            
                            SET @v_cantidadSalida = 0;
						ELSE                            
                            UPDATE kardex_temp2 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSaldo,
								activo = 0
							WHERE idDetaNota = @v_idDetaNota2;
                            
							UPDATE temp_entradas 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSaldo,
								activo = 0
							WHERE idDetaNota = @v_idDetaNota2;
                            
                            UPDATE kardex_temp2 SET activo = 0  WHERE tipoNota = 'S' and costoUnitarioSaldo = @v_costoUnitarioEntrada;
                            
                            INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cantidadSalida, costoUnitarioSalida, costoTotalSalida,
								cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
							SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cast( round(@v_cantidadSaldo, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round( @v_cantidadSaldo * @v_costoUnitarioEntrada, 2)  as decimal(18,2)),
								0, @v_costoUnitarioEntrada, 0, 
								tipoNota, activo, cantidadUsada
							FROM kardex_temp k WHERE idDetaNota = @v_idDetaNota;                           
                            
                            SET @v_cantidadSalida = @v_cantidadSalida - @v_cantidadSaldo;
						END IF;
                        
						SET @nFilas2 = @nFilas2 - 1;
					END WHILE;
				END IF;
            END IF;
            
            DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;	
			SET @nFilas = @nFilas - 1;
		END WHILE;
		
        UPDATE KARDEX_TEMP2 set cantidadSaldo = '', costoUnitarioSaldo = '', costoTotalSaldo = '' 
        WHERE cantidadSaldo = 0;
        
        UPDATE KARDEX_TEMP2 set activo = 0
        WHERE cantidadUsada > 0;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM KARDEX_TEMP2 k;
	END IF;
    
    IF tipoOperacion = 9 THEN -- PROMEDIO
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '00' 
					 WHEN NA.tipoNota = 'S' THEN '00'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 -- WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 -- WHEN NA.tipoNota = 'S'  THEN '001'
                     WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NE'
					 WHEN NA.tipoNota = 'S'  THEN ''
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					-- WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				-- END as tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN concat(M2.Abrev, '-', M2.descripcion)
					 WHEN NA.tipoNota = 'S' THEN concat(M3.Abrev, '-', M3.descripcion ) 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
								CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE 0 END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaContable) = p_anio
        		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
    
    IF tipoOperacion = 10 THEN -- PEPS
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '00' 
                     WHEN NA.tipoNota = 'S' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'S' THEN '00'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 -- WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 -- WHEN NA.tipoNota = 'S'  THEN '001'
                     WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NE'
                     WHEN NA.tipoNota = 'S' and NA.tipoDocumento is not null THEN NA.serieDocumento 
                     WHEN NA.tipoNota = 'S'  THEN ''
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
                     WHEN NA.tipoNota = 'S' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 -- WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				-- END as tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN concat(M2.Abrev)
					 WHEN NA.tipoNota = 'S' THEN concat(M3.Abrev) 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
								CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 1 as activo, 0 cantidadUsada
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaContable) = p_anio
        		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
        
		CREATE TEMPORARY TABLE kardex_temp2(SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		delete from kardex_temp2;
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        set @contador = 1;
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
				@v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
                
			IF(@contador = 1) THEN
				INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
					tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
					cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
					cantidadSalida, costoUnitarioSalida, costoTotalSalida,
					cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
				SELECT * 
				FROM kardex_temp LIMIT 1;
                
                set @contador = 2;
			ELSE
				DROP TEMPORARY TABLE IF EXISTS temp_entradas;
				
				CREATE TEMPORARY TABLE temp_entradas (
					SELECT * FROM kardex_temp2 
					WHERE fechaContable <= @v_fechaContable AND activo = 1 AND tipoNota = 'E'
				);
                SET @nFilas2 = (SELECT count(*) FROM temp_entradas);
				                
				IF ( @v_tipoNota = 'E') THEN
                        
					INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
						tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
						cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
						cantidadSalida, costoUnitarioSalida, costoTotalSalida,
						cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
					SELECT *
					FROM kardex_temp WHERE idDetaNota = @v_idDetaNota;
                    
                    WHILE @nFilas2 > 0 DO
						SET @v_idDetaNota2 = 0;
						SET @v_cantidadSaldo = 0;
                        
						SELECT idDetaNota, cantidadEntrada - cantidadUsada
						INTO @v_idDetaNota2, @v_cantidadSaldo
						FROM temp_entradas 
                        WHERE activo = 1 and costoUnitarioEntrada =  @v_costoUnitarioEntrada
						ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                        
                        UPDATE kardex_temp2 
                        SET cantidadSaldo = cast( round(cantidadSaldo + @v_cantidadSaldo, 2)  as decimal(18,2)),
							costoTotalSaldo = cast( round( cantidadSaldo * costoUnitarioSaldo, 2)  as decimal(18,2))
                        WHERE idDetaNota = @v_idDetaNota;
                        
						UPDATE kardex_temp2
                        SET cantidadUsada = cast( round(cantidadSaldo, 2)  as decimal(18,2)),
							activo = 0
                        WHERE idDetaNota = @v_idDetaNota2;
                        
						SET @nFilas2 = @nFilas2 - 1;
					END WHILE;
				ELSE 
					WHILE @nFilas2 > 0 and @v_cantidadSalida > 0 DO
						set @v_idDetaNota2 = 0;
						set @v_cantidadSaldo = 0;
                        set @v_costoUnitarioEntrada = 0;
                        
						SELECT idDetaNota, costoUnitarioEntrada, cantidadEntrada - cantidadUsada
						INTO @v_idDetaNota2, @v_costoUnitarioEntrada, @v_cantidadSaldo
						FROM temp_entradas 
                        WHERE activo = 1
						ORDER BY date(fechaContable) asc, idDetaNota asc limit 1;
                        
                        IF @v_cantidadSalida <= @v_cantidadSaldo THEN
                        
							UPDATE kardex_temp2 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSalida, 
								activo = ( CASE WHEN  @v_cantidadSalida = @v_cantidadSaldo THEN 0 ELSE 1 END)
							WHERE idDetaNota = @v_idDetaNota2;
                            
                            UPDATE kardex_temp2 SET activo = 0  WHERE tipoNota = 'S' and costoUnitarioSaldo = @v_costoUnitarioEntrada;
                            
                            INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cantidadSalida, costoUnitarioSalida, costoTotalSalida,
								cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
							SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cast( round(@v_cantidadSalida, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round(cantidadSalida * @v_costoUnitarioEntrada, 2)  as decimal(18,2)),
								cast( round(@v_cantidadSaldo - @v_cantidadSalida, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round( (@v_cantidadSaldo - @v_cantidadSalida)  * @v_costoUnitarioEntrada, 2)  as decimal(18,2)), 
								tipoNota, activo, cantidadUsada
							FROM kardex_temp k WHERE idDetaNota = @v_idDetaNota;
                            
                            SET @v_cantidadSalida = 0;
						ELSE                            
                            UPDATE kardex_temp2 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSaldo,
								activo = 0
							WHERE idDetaNota = @v_idDetaNota2;
                            
							UPDATE temp_entradas 
                            SET cantidadUsada = cantidadUsada + @v_cantidadSaldo,
								activo = 0
							WHERE idDetaNota = @v_idDetaNota2;
                            
                            UPDATE kardex_temp2 SET activo = 0  WHERE tipoNota = 'S' and costoUnitarioSaldo = @v_costoUnitarioEntrada;
                            
                            INSERT INTO kardex_temp2 (idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cantidadSalida, costoUnitarioSalida, costoTotalSalida,
								cantidadSaldo, costoUnitarioSaldo, costoTotalSaldo, tipoNota, activo, cantidadUsada)
							SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
								tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion, 
								cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
								cast( round(@v_cantidadSaldo, 2)  as decimal(18,2)), @v_costoUnitarioEntrada, cast( round( @v_cantidadSaldo * @v_costoUnitarioEntrada, 2)  as decimal(18,2)),
								0, @v_costoUnitarioEntrada, 0, 
								tipoNota, activo, cantidadUsada
							FROM kardex_temp k WHERE idDetaNota = @v_idDetaNota;                           
                            
                            SET @v_cantidadSalida = @v_cantidadSalida - @v_cantidadSaldo;
						END IF;
                        
						SET @nFilas2 = @nFilas2 - 1;
					END WHILE;
				END IF;
            END IF;
            
            DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;	
			SET @nFilas = @nFilas - 1;
		END WHILE;
		
        UPDATE kardex_temp2 set cantidadSaldo = '', costoUnitarioSaldo = '', costoTotalSaldo = '' 
        WHERE cantidadSaldo = 0;
        
        UPDATE kardex_temp2 set activo = 0
        WHERE cantidadUsada > 0;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
    
    IF tipoOperacion = 11 THEN -- PROMEDIO
		DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '00' 
                     WHEN NA.tipoNota = 'S' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'S' THEN '00'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 -- WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 -- WHEN NA.tipoNota = 'S'  THEN '001'
                     WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NE'
                     WHEN NA.tipoNota = 'S' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'S'  THEN ''
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
                     WHEN NA.tipoNota = 'S' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					-- WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				-- END as tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN concat(M2.Abrev)
					 WHEN NA.tipoNota = 'S' THEN concat(M3.Abrev) 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
								CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE 0 END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and year(NA.fechaContable) = p_anio
        		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
        SELECT idDetaNota, idNotaAlmacen, idProducto, fechaContable, fecha, fechaFormato, fechaUso, fechaUsoFormato,
			tipoDocumento, serieDocumento, numeroDocumento, placa, k.tipoOperacion,
			cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
			case when cantidadSalida = 0 then ''
			else cantidadSalida end as cantidadSalida, costoUnitarioSalida, costoTotalSalida,
			case when cantidadSaldo = 0 then ''
			else cantidadSaldo end as cantidadSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoUnitarioSaldo end as costoUnitarioSaldo, 
            case when cantidadSaldo = 0 then ''
			else costoTotalSaldo end as costoTotalSaldo,
			tipoNota,
			case when cantidadSaldo = 0 then 0
			else activo end as activo
		FROM kardex_temp2 k;
	END IF;
END
$